//
//  NovusHelper.h
//  Emcom
//
//  Created by Karl Løland on 10/18/11.
//  Copyright 2011 Altinett AS. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NovusAPI.h"

@interface ECNovusHelper : NSObject{
    
}
#pragma MARK - Singleton
+ (id <NovusAPI>) proxyObject;

#pragma MARK - Installation
+ (BOOL) installPkg: (NSString*) pkg withInstallPath: (NSString*) installPath;
+ (BOOL) installApplication: (NSString*) app toPath: (NSString*) path;
+ (BOOL) installCompressedApplication: (NSString*) app toPath: (NSString*) path;
+ (BOOL) updateApplicationWithIdentifier: (NSString*) identifier withNewApplication: (NSString*) newApp;
+ (BOOL) installNetworkSettingsForModem:(NSString*)modemName withName:(NSString*) name;
+ (BOOL) installDaemonWithIdentifier: (NSString*) identifier andBinary: (NSString*) binaryPath;
+ (BOOL) changeFileNameFrom:(NSString*) oldPath to:(NSString*) newPath;

#pragma MARK - Uninstallation
//Uninstall methods:
+ (BOOL) removeFile:(NSString*) path;
+ (BOOL) removeFolder:(NSString*) path;
+ (BOOL) removeAndUnregisterHelperWithIdentifier:(NSString*) identifier;
+ (BOOL) removeAndUnregisterKextWithIdentifier:(NSString*) identifier;
+ (BOOL) removeMobilePartner;
+ (void) restartDock;
+ (BOOL) killApplication:(NSString*) identifier;
#pragma MARK - Settings

+ (BOOL) changeIconForBundle:(NSString*)bundle withIcon:(NSString*) iconName;


@end
